#include "aic_txrxif.h"
#include "aicwf_usb.h"
#include "aicbluetooth.h"
#include "aic_compat_8800d80.h"
#include "aicwf_debug.h"

int rwnx_plat_bin_fw_upload_2(struct aic_usb_dev *usbdev, u32 fw_addr,
                               char *filename);
int rwnx_request_firmware_common(struct aic_usb_dev *usbdev,
	u32** buffer, const char *filename);
void rwnx_plat_userconfig_parsing(char *buffer, int size);
void rwnx_release_firmware_common(u32** buffer);

extern int testmode;
extern int chip_id;

typedef u32 (*array2_tbl_t)[2];

#define AIC_PATCH_MAGIG_NUM     0x48435450 // "PTCH"
#define AIC_PATCH_BLOCK_MAX     4

typedef struct {
    uint32_t magic_num;
    uint32_t pair_start;
    uint32_t pair_count;
    uint32_t block_dst[AIC_PATCH_BLOCK_MAX];
    uint32_t block_src[AIC_PATCH_BLOCK_MAX];
    uint32_t block_size[AIC_PATCH_BLOCK_MAX]; // word count
} aic_patch_t;

#ifdef AICWF_USB_SUPPORT
u32 patch_tbl_d80[][2] =
{
    {0x0044, 0x00000002}, //hosttype
    {0x0048, 0x00000060}, //pkt_cnt_128=0x60, pkt_cnt_1600=0x00
    #if defined(CONFIG_MCU_MESSAGE)
    {0x004c, 0x00000040}, //pkt_cnt_1724=0x40
    {0x0050, 0x0011FC00}, //ipc_base_addr
    #else
    {0x004c, 0x00000046},
    {0x0050, 0x00000000}, //ipc base
    #endif
    {0x0054, 0x001a0000}, //buf base
    {0x0058, 0x001a0140}, //desc base
    {0x005c, 0x00001020}, //desc size
    {0x0060, 0x001a1020}, //pkt base
    {0x0064, 0x000207e0}, //pkt size
    {0x0068, 0x00000008},
    {0x006c, 0x00000040},
    {0x0070, 0x00000040},
    {0x0074, 0x00000020},
    {0x0078, 0x00000000},
    {0x007c, 0x00000040},
    {0x0080, 0x00190000}, //ringbuf
    {0x0084, 0x0000fc00}, //63kB
    {0x0088, 0x0019fc00},
    {0x00A8, 0x8F080103}, //dm
    #ifdef USE_5G
    {0x00b4, 0xf3010001},
    #else
    {0x00b4, 0xf3010000},
    #endif
    //{0x00b8, 0x0f010a01}, //tx enhanced en, tx enhanced lo rate
    {0x00BC, 0x0A080108}, //txgain_enhance_highrate, pwridx_en, dsss, lowrate_2g4
    {0x00C0, 0x09080808}, //64qam_2g4, 256qam_2g4, 1024qam_2g4, lowrate_5g
    {0x00C4, 0x00080909}, //64qam_5g, 256qam_5g, 1024qam_5g, pwrofst_en
    //{0x00D0, 0x00010103}, //aon sram
    //{0x00D4, 0x0000087C},
    //{0x00D8, 0x001C0000}, //bt base
    //{0x00DC, 0x00008000}, //bt size
#if 1
    {0x00E0, 0x04020A08}, //fc param
    {0x00E4, 0x00000001}, //fc algo1
#else
    {0x00E0, 0x04010703}, //fc param
    {0x00E4, 0x00000000}, //fc algo0
#endif
};
#else
#ifdef CONFIG_ROM_PATCH_EN
u32 patch_tbl_d80[][2] =
{
    {0x0044, 0x02000001},
    {0x0058, 0x001a0000},
    {0x005c, 0x00002020},
    {0x0060, 0x001a2020}, //pkt base
    {0x0064, 0x00021820}, //pkt size
    {0x0080, 0x00190000},
    {0x0084, 0x0000fc00},//63kB
    {0x0088, 0x0019fc00}
};
#else
u32 patch_tbl_d80[][2] =
{
    #if defined(CONFIG_MCU_MESSAGE)
    {0x004c, 0x0000004B}, //pkt_cnt_1724=0x4B
    {0x0050, 0x0011FC00}, //ipc_base_addr
    #endif
    #ifdef USE_5G
    {0x00b4, 0xf3010001},
    #else
    {0x00b4, 0xf3010000},
    #endif
};
#endif
#endif

u32 patch_tbl_1[14][2] =
{
    {0x171b24, 0x1c4021}, //61
    {0x171c00, 0x1c40b1}, //116
    {0x172124, 0x1c43ed}, //12*8 + 1720c4
    {0x171bfc, 0x1c4849}, //115,  171a30 + 115 * 4
    {0x171ee4, 0x1c4941}, //301
    {0x171ee8, 0x1c4b09}, //302
    {0x172134, 0x1c4d65}, //14/15/16/17/18 * 8 + 1720c4{0x172134, 0x1c4d65},
    {0x17213c, 0x1c4d65},
    {0x172144, 0x1c4d65},
    {0x17214c, 0x1c4d65},
    {0x172154, 0x1c4d65},
    {0x1721d0, 0x1c53dd}, // 1721c4 + 1*8 + 4
    {0x1721f0, 0x1c5415}, // 1721c4 + 5*8 + 4
    {0x171eb0, 0x1c54a1}, // 288
};

u32 func_tbl[1721] =
{
    0x8cc88cc3,
    0xd8084283,
    0x1ac0d205,
    0xbfcc283f,
    0x20012000,
    0x20014770,
    0x20004770,
    0xbf004770,
    0x481d4a1c,
    0xb538491d,
    0x68056913,
    0xf8b16914,
    0xf8b100b0,
    0xf5a310b2,
    0xeb0363fa,
    0x1b1b1345,
    0x1a5b1a1b,
    0xdb1a2b00,
    0x681b4b15,
    0x68dcb143,
    0x1ae36913,
    0x63faf5a3,
    0x1a5b1a1b,
    0xdb012b00,
    0xbd382001,
    0x681b4b0f,
    0x3000f9b3,
    0xda062b00,
    0x1ae46913,
    0x549cf504,
    0x2c003408,
    0x2000db01,
    0x4909bd38,
    0xf44f4809,
    0xf66b7202,
    0x2000fad9,
    0xbf00bd38,
    0x40501000,
    0x40328040,
    0x0017192c,
    0x00178bf0,
    0x00173250,
    0x001c5a3c,
    0x001c56b4,
    0x4ff0e92d,
    0x8c05461c,
    0x3062f893,
    0x9020f8d2,
    0xf8d06987,
    0xb089b01c,
    0x02ad4616,
    0x2012e9dd,
    0xf8b4b9d3,
    0xf1bcc068,
    0xd0150f00,
    0x6ab38b52,
    0xf202fb0c,
    0x07189205,
    0xf20cfb05,
    0xd0199206,
    0xebb72300,
    0xf44f0a09,
    0x930776fa,
    0xf5039b05,
    0xe9c473c8,
    0xe071a31f,
    0xf0402800,
    0x950680ba,
    0x0a01f04f,
    0x6ab28b50,
    0xf000fb0a,
    0x90050712,
    0x8122f040,
    0xf8df6af2,
    0xf8dfc2bc,
    0xf8dc82bc,
    0x48983000,
    0x1203f3c2,
    0x037ff023,
    0x2002f818,
    0xf8cc4313,
    0x6ab33000,
    0xf3c34a93,
    0xea4113c0,
    0xf04f5103,
    0x60014300,
    0xf3bf6013,
    0xbf008f4f,
    0x00586813,
    0x4b8dd5fc,
    0xf9b16819,
    0x29001000,
    0x80aef2c0,
    0x68124a88,
    0xfa82fa1f,
    0x07126ab2,
    0x809df040,
    0xf8df6af2,
    0x4882c25c,
    0x1000f8dc,
    0x1203f3c2,
    0x017ff021,
    0x2002f818,
    0xf8cc430a,
    0x6ab22000,
    0xf3c2497c,
    0x051212c0,
    0x0218f042,
    0x4600f04f,
    0x600e6002,
    0x8f4ff3bf,
    0x680abf00,
    0xd5fc0056,
    0xf9b3681b,
    0x2b003000,
    0x4a72db6e,
    0x3062f894,
    0x22006816,
    0xebaab2b6,
    0x92070a06,
    0x0909ebb7,
    0x0a0aeb19,
    0xd0872b00,
    0x79e5ea4f,
    0x464b462a,
    0x46594638,
    0xfc50f679,
    0x92021bba,
    0xfb009a07,
    0xeb6bf309,
    0xfb050202,
    0x92033301,
    0x0105fba0,
    0xe9dd4419,
    0x42992302,
    0x4290bf08,
    0xe9cdbf38,
    0x4b5e0102,
    0x6702e9dd,
    0x9b066819,
    0x018918f6,
    0x9905d430,
    0xf5a11a71,
    0x4b597ac8,
    0x69194a59,
    0x691b6812,
    0x44511a89,
    0xf5a31acb,
    0x3b1453a5,
    0x6a632b00,
    0x1949bfb8,
    0xd022428b,
    0x6a1a4b52,
    0xd04142a2,
    0xf1044d51,
    0xf8d50018,
    0x479831e0,
    0x30a8f8d5,
    0xb0094620,
    0x4ff0e8bd,
    0xf8904718,
    0xf1baa002,
    0xd1010f00,
    0xa003f890,
    0xf00afb05,
    0xe73d9006,
    0x98054946,
    0xeba11a09,
    0x44b20a0a,
    0xb009e7cb,
    0x8ff0e8bd,
    0x0058680b,
    0x4941d48d,
    0xf44f4841,
    0xf66b72ae,
    0x2200f98f,
    0x3062f894,
    0xf5aa9207,
    0xf44f7afa,
    0xe78776fa,
    0x00516812,
    0xaf4ef53f,
    0x48384937,
    0x72aef44f,
    0xf97cf66b,
    0x7afaf44f,
    0xe7474b2c,
    0x62614a2c,
    0x01926812,
    0x4a32d4b8,
    0x68124d32,
    0x1024f893,
    0x4207f3c2,
    0x2d23f885,
    0x4a2fbb61,
    0x6812492f,
    0x20016809,
    0xf885b2d2,
    0xf8832d24,
    0x780b0024,
    0xd1054283,
    0x4a2b492a,
    0x6813600b,
    0x60134303,
    0x2d23f895,
    0x3d24f895,
    0xd21b429a,
    0x681b4b17,
    0x3000f9b3,
    0xda0d2b00,
    0x2d23f895,
    0x3d24f895,
    0xd307429a,
    0x48214920,
    0xf44f4d15,
    0xf66b7221,
    0xe787f96f,
    0xe7854d12,
    0xf44f2200,
    0x920776fa,
    0xe7354692,
    0x4b124814,
    0x1d23f895,
    0x2d24f895,
    0x6806681b,
    0xb2f64816,
    0x96000c1b,
    0xff82f66a,
    0xbf00e7d4,
    0x40328160,
    0x4032816c,
    0x00173250,
    0x4032004c,
    0x40501000,
    0x403280a4,
    0x00178d3c,
    0x00171a30,
    0xfffffe70,
    0x001c5a20,
    0x001c56e0,
    0x40328044,
    0x001e4000,
    0x40320090,
    0x00173270,
    0x40328070,
    0x40328074,
    0x001c5a58,
    0x001c5718,
    0x001c5704,
    0x40328164,
    0x00041830,
    0x4ff0e92d,
    0x9354f8df,
    0xb020f8d9,
    0xf44fb083,
    0xf6692000,
    0xf1bbfd9b,
    0xf0000f00,
    0x4cb480f1,
    0xa33cf8df,
    0x4fb37fa1,
    0x8338f8df,
    0x29004eb2,
    0x80e6f000,
    0xd50e0708,
    0xf8db4bb0,
    0x681b0070,
    0x2010f8da,
    0x4403685b,
    0x2b001a9b,
    0x80c7f2c0,
    0x01f7f001,
    0x074a77a1,
    0x8095f100,
    0xd515078b,
    0x3004f8db,
    0x0302f023,
    0x3004f8cb,
    0x301df899,
    0xd1082b05,
    0x48a34da2,
    0x31d8f8d5,
    0x23004798,
    0xf8897fa1,
    0xf001301d,
    0x77a101fd,
    0xd52d07cd,
    0x01586833,
    0x809ff140,
    0x0c096831,
    0x7f7cf411,
    0x80a6f000,
    0x4b983910,
    0x01fff001,
    0x1281eb01,
    0x03c2eb03,
    0x2021f893,
    0xf0002a00,
    0x4a93809d,
    0x68137f99,
    0xf9b34a92,
    0xf44f3000,
    0xfb0060a4,
    0x2b002201,
    0xf2c09200,
    0x683b809c,
    0x2fe0f413,
    0x80a5f000,
    0xf0017fa1,
    0x77a101fe,
    0xd59e068a,
    0x49894e88,
    0xf3c56835,
    0x463a1741,
    0xf66a2002,
    0x2300ff23,
    0x1547f3c5,
    0x3078f88b,
    0xf0402f00,
    0x4e7b80af,
    0x4d824a81,
    0xf4236813,
    0x60137300,
    0x3004f8db,
    0x21d8f8d6,
    0x0301f023,
    0x3004f8cb,
    0x0028f10b,
    0x682a4790,
    0x2b027813,
    0x8114f000,
    0x680b4974,
    0x0301f023,
    0x7813600b,
    0xd1122b01,
    0x41fff501,
    0x4a733134,
    0x3010f8da,
    0xf8b26808,
    0xf8d610b2,
    0xeb0321e0,
    0x1a591340,
    0x0018f10b,
    0x682b4790,
    0x2b02781b,
    0x80b4f000,
    0xf0017fa1,
    0x77a101df,
    0x4968e74f,
    0x20024d5d,
    0xfedcf66a,
    0x68634966,
    0xf022680a,
    0x600a0204,
    0xf4436822,
    0x431a7300,
    0xf8d5614a,
    0x60631498,
    0x0063f89b,
    0x3494f8d5,
    0x4798465a,
    0x7fa1683b,
    0x737cf023,
    0xf8d8603b,
    0xf0013000,
    0xf44301fb,
    0xf8c80380,
    0x77a13000,
    0x4856e742,
    0xfe66f66a,
    0x2200e782,
    0x006cf89b,
    0xf6584611,
    0xb160fd17,
    0xe72f7fa1,
    0xf66a4850,
    0xe775fe59,
    0xf66a484f,
    0xe771fe55,
    0xe8bdb003,
    0xf8da8ff0,
    0x7fa13010,
    0x3070f8cb,
    0x4593e71e,
    0xaf61f43f,
    0x48494948,
    0x22e6f240,
    0xf818f66b,
    0xf413683b,
    0xf47f2fe0,
    0x6832af5b,
    0x49446833,
    0xf3c30fd0,
    0x46057380,
    0x20024602,
    0xf66a9301,
    0x9b01fe81,
    0x0205ea53,
    0xf43f4628,
    0x4d2baf49,
    0x46199a00,
    0x323cf8d5,
    0x68334798,
    0x4300f023,
    0x68336033,
    0x4380f023,
    0xe7396033,
    0x2010f8da,
    0x529cf502,
    0x32084631,
    0xf8dae005,
    0x1ad33010,
    0xf2c02b00,
    0x680b80b2,
    0xd5f6071b,
    0x8080f8df,
    0x3000f8d8,
    0x0308f023,
    0x3000f8c8,
    0x3000f8d8,
    0xd51206de,
    0x49274e15,
    0xf66a2002,
    0xf8d6fe4b,
    0xf005323c,
    0x08780101,
    0x4798465a,
    0x3000f8d8,
    0x0310f023,
    0x3000f8c8,
    0x4b1fe722,
    0x4e0b491f,
    0x601d2501,
    0xf66a2002,
    0x4b1dfe35,
    0xe717601d,
    0x22304b1c,
    0xf657601a,
    0xe745fddb,
    0x00178bb8,
    0x40320074,
    0x40320070,
    0x00173244,
    0x00171a30,
    0x00178d48,
    0x00175aa8,
    0x00173250,
    0x00177738,
    0x4032008c,
    0x001c57ec,
    0x4033b390,
    0x00173270,
    0x0017192c,
    0x001c578c,
    0x4032004c,
    0x001c5790,
    0x001c57a8,
    0x001c57bc,
    0x001c5a70,
    0x001c57d0,
    0x001c57e0,
    0x001c580c,
    0x40328564,
    0x001c5818,
    0x40328568,
    0x40320038,
    0x00178d3c,
    0x40501000,
    0x4032006c,
    0x8310f3ef,
    0xd40307d8,
    0x4b31b672,
    0x601a2201,
    0x4f314b30,
    0x3201681a,
    0x2100601a,
    0x6039683a,
    0x080ff002,
    0x2010f8da,
    0x46164631,
    0xf247460a,
    0xe0045030,
    0x1010f8da,
    0x42811b89,
    0x6839d81b,
    0xd1f70709,
    0x49264825,
    0xc000f8d0,
    0x4616680f,
    0x2010f8da,
    0x0f00f1b8,
    0x4a22d11a,
    0x60112104,
    0xb132681a,
    0x3a01491a,
    0x680b601a,
    0xb103b90a,
    0x682ab662,
    0x491ce6b0,
    0x20029200,
    0xfdb0f66a,
    0x9a004b14,
    0x4919e7d3,
    0xf66a2002,
    0xe74bfda9,
    0x070cea07,
    0xd4e0077f,
    0x1600e9cd,
    0x46164680,
    0x077ae001,
    0x9a00d412,
    0x7000f8d8,
    0xf8da6812,
    0xf2471010,
    0x1b895030,
    0xea074281,
    0xd9f00702,
    0x2002490b,
    0xfd8cf66a,
    0xe7ea4b02,
    0xe7c49e01,
    0x0017569c,
    0x00172600,
    0x40320038,
    0x4032806c,
    0x40328074,
    0x40328070,
    0x001c5828,
    0x001c57f8,
    0x001c5834,
    0xf890b5f8,
    0x2b003064,
    0xf890d03a,
    0x4604308a,
    0xd1362b00,
    0xf8944e32,
    0x4a32306c,
    0x6a674932,
    0xeb036a09,
    0xeb021383,
    0x42a103c3,
    0x443d685d,
    0xf8d6d044,
    0x462931e0,
    0x0018f104,
    0x46204798,
    0xfafaf65e,
    0x1080f8d4,
    0x3214f8d6,
    0x46204439,
    0xf8d64798,
    0x462a30a4,
    0x46204639,
    0xb9784798,
    0x3078f894,
    0x49216862,
    0xb2db3301,
    0x0201f042,
    0xf8846809,
    0x60623078,
    0x4293780a,
    0xd029d811,
    0x3b01bdf8,
    0x2b01b2db,
    0x308af880,
    0x2b02d912,
    0xd1c04e13,
    0x0063f890,
    0x31c0f8d6,
    0x47982100,
    0xf8d6e7b9,
    0xf8941164,
    0x4622006c,
    0x40f8e8bd,
    0xbb84f658,
    0x40f8e8bd,
    0xbb3af65e,
    0x62654b0c,
    0x30b5f893,
    0xd1ba2b00,
    0x681b4b0a,
    0x2b02781b,
    0xe7b4d1af,
    0xe8bd4620,
    0xf66540f8,
    0xbf00b8d1,
    0x00171a30,
    0x00175aa8,
    0x00178d3c,
    0x00173244,
    0x0017192c,
    0x00173270,
    0x4c5cb538,
    0x68224b5c,
    0xf002495c,
    0x701a020f,
    0xf66a2002,
    0x6823fcef,
    0xd02e0718,
    0x4a594958,
    0x2000680b,
    0x4300f023,
    0x6020600b,
    0x07596813,
    0x4b55d5fc,
    0x4a554952,
    0x60182004,
    0xf043680b,
    0x600b4300,
    0xf0436813,
    0x60136300,
    0x20024950,
    0xfcd0f66a,
    0x4a4f4b47,
    0x494f4847,
    0x601c2420,
    0x24016813,
    0x0310f043,
    0x70446013,
    0x781b680b,
    0xd0382b03,
    0xd0062b01,
    0x4a44bd38,
    0xf0236813,
    0x60136300,
    0x4a45e7e2,
    0x035b6813,
    0x4a44d5fc,
    0x311c6911,
    0x1acb6913,
    0xdafb2b00,
    0x681c4b41,
    0x4b41b174,
    0xf9b3681b,
    0x2b003000,
    0x4a3fdb4e,
    0xf8b268e3,
    0x4a3a10b2,
    0x21041a5b,
    0x60916313,
    0x4a3c493b,
    0xf443680b,
    0x600b4300,
    0xf4436d13,
    0x65134300,
    0xf0236dd3,
    0xf0430303,
    0xf0434300,
    0x65d30301,
    0x4b2fbd38,
    0xb174681c,
    0x681b4b2e,
    0x3000f9b3,
    0xdb152b00,
    0x68e34a2c,
    0x10b2f8b2,
    0x1a5b4a27,
    0x63132104,
    0x4b2b6091,
    0xf042681a,
    0x601a0201,
    0x075a681b,
    0x4b28d5ae,
    0x7200f44f,
    0xbd38601a,
    0x4d214b1e,
    0x68e3691a,
    0x10b2f8b5,
    0x1a521a9a,
    0xdae32a00,
    0x48224921,
    0x32dbf240,
    0xfddef66a,
    0xf8b568e3,
    0xe7d910b2,
    0x69124d17,
    0xf8b568e3,
    0x1a9a10b2,
    0x2a001a52,
    0x4918daab,
    0xf2404818,
    0xf66a32e9,
    0x68e3fdcb,
    0x10b2f8b5,
    0xbf00e7a1,
    0x40320038,
    0x00172604,
    0x001c5844,
    0x40328074,
    0x4032806c,
    0x40328070,
    0x40328048,
    0x001c584c,
    0x40580010,
    0x00173274,
    0x40041020,
    0x40501000,
    0x00178bf0,
    0x00173250,
    0x0017192c,
    0x40240014,
    0x40506000,
    0x40044084,
    0x40044100,
    0x001c5a8c,
    0x001c5854,
    0xf890b380,
    0xb36b3064,
    0x47f0e92d,
    0x4a7b4b7a,
    0xf8df4e7b,
    0xf8df920c,
    0x4d7a8240,
    0x460c487a,
    0x2702497a,
    0xc470f8d1,
    0x7180f8c3,
    0x49786892,
    0xc044f8c2,
    0x601f2201,
    0xf8d97032,
    0x680b2010,
    0xf0236072,
    0x600b0302,
    0x1000f8d8,
    0xc0b2f8b5,
    0x68018f8b,
    0xebb34463,
    0xea4f1f41,
    0xd3021a41,
    0x87f0e8bd,
    0x496b4770,
    0xf66a4638,
    0xf8d9fbdf,
    0x68f32010,
    0x2b001a9b,
    0xf2804b67,
    0xf89380a2,
    0xf8932d23,
    0x2a012d24,
    0xf893d90a,
    0x68612d23,
    0xf0002a00,
    0xf893809e,
    0x3a012d23,
    0xaa02fb01,
    0x3d23f893,
    0x4652495d,
    0xf66a2002,
    0xf8d8fbbf,
    0xf8b53000,
    0x8f9a00b2,
    0x4b594955,
    0xc178f8df,
    0x680b691c,
    0xebaa4402,
    0xf0220202,
    0xf0030703,
    0x433b0303,
    0x600b4f53,
    0x60b2683b,
    0x0301f043,
    0xf8dc603b,
    0xf8dc3000,
    0xf3c31000,
    0xf4210309,
    0xf043717f,
    0xf0210301,
    0x430b0103,
    0x3000f8cc,
    0x4422683b,
    0x60f2075b,
    0x4b47d503,
    0x7200f44f,
    0x4a46601a,
    0x68134c46,
    0xf043493d,
    0x60130308,
    0xf0436823,
    0x60230302,
    0xf5a2680b,
    0x3a1022fe,
    0x0301f043,
    0x6911600b,
    0x7196f501,
    0x1a5b6913,
    0xdbfb2b00,
    0x681b4b3b,
    0x2b01781b,
    0x493ad188,
    0x6a4b4c3a,
    0xf0236824,
    0xf04303ff,
    0x624b03df,
    0xf4236a4b,
    0xf443437f,
    0x624b435f,
    0x4b34b194,
    0xf9b3681b,
    0x2b003000,
    0x68e2db31,
    0x48316861,
    0xfb04f66a,
    0x10b2f8b5,
    0x4a2568e3,
    0x21041a5b,
    0x60916313,
    0x4a28492c,
    0xf443680b,
    0x600b4300,
    0xf4436d13,
    0x65134300,
    0xf0236dd3,
    0xf0430303,
    0xf0434300,
    0x65d30301,
    0xf4436813,
    0x60135380,
    0x4922e74e,
    0x3d23f893,
    0x46524638,
    0xfb2ef66a,
    0xf893e76d,
    0x3a012d24,
    0xaa02fb01,
    0x6913e760,
    0x1ad368e2,
    0x28001a18,
    0x4919dac8,
    0xf2404819,
    0xf66a4231,
    0xe7c0fca1,
    0xe000e100,
    0xe000ed00,
    0x00173254,
    0x0017192c,
    0x40328040,
    0x00171a30,
    0x40320084,
    0x001c589c,
    0x001e4000,
    0x001c58b8,
    0x40501000,
    0x40044084,
    0x40044100,
    0x40580010,
    0x40580018,
    0x00173274,
    0x40506000,
    0x00178bf0,
    0x00173250,
    0x001c58c8,
    0x40240014,
    0x001c58a4,
    0x001c5aac,
    0x001c5854,
    0x00173244,
    0x4ff0e92d,
    0x4abd4bbc,
    0xf852681b,
    0xf9b34020,
    0x4abb3000,
    0x8b02ed2d,
    0x02c0eb02,
    0xee082b00,
    0xb08b2a10,
    0xea4f4683,
    0xf2c005c0,
    0x462082c4,
    0xf8d0f669,
    0xf8534bb2,
    0xf1b9903b,
    0xf0000f00,
    0x230080e5,
    0x3303e9cd,
    0xf5059302,
    0x9301629e,
    0xf10b469a,
    0x9208039e,
    0x464c9305,
    0xf898e079,
    0x06df3004,
    0x80d2f140,
    0xf4226932,
    0x9a010900,
    0x9010f8c6,
    0x065d3201,
    0xf1009201,
    0x4fa180e0,
    0xf8d74620,
    0x47983418,
    0xf4036b63,
    0xf5b31360,
    0xbf081f20,
    0xf3ef46a2,
    0x07d98310,
    0xb672d403,
    0x22014b99,
    0x4d99601a,
    0xee18682b,
    0x33010a10,
    0xf669602b,
    0x6b63f951,
    0x1360f403,
    0x1f60f5b3,
    0x80a9f000,
    0xb133682b,
    0x3b014a8f,
    0x602b6812,
    0xb102b90b,
    0xf8dfb662,
    0xf8d88240,
    0x78193000,
    0xf419b391,
    0xd1050300,
    0x002ef9b4,
    0x28008de2,
    0x817ef2c0,
    0x302cf894,
    0x202af894,
    0xf8b44884,
    0xeb03c008,
    0x441303c3,
    0x530ef203,
    0xf8502901,
    0xeba22023,
    0xf840020c,
    0xf0002023,
    0x6ce080d5,
    0xf650b138,
    0xf8d8fd4f,
    0x781e3000,
    0xf0002e01,
    0x4621810f,
    0xf66a4658,
    0x6b63fc95,
    0x1360f403,
    0x1f60f5b3,
    0x80eaf000,
    0xf8534b6d,
    0x2c00403b,
    0xf8d4d05c,
    0x6d268048,
    0x0f00f1b8,
    0xaf7ff47f,
    0x8310f3ef,
    0xd40307d9,
    0x4b67b672,
    0x601a2201,
    0x682b4d66,
    0x0a10ee18,
    0x602b3301,
    0xf8ecf669,
    0xb133682b,
    0x3b014a60,
    0x602b6812,
    0xb102b90b,
    0x4f5cb662,
    0x9178f8df,
    0x817cf8df,
    0xf6764620,
    0xf8d7ff21,
    0x46203418,
    0xf8d74798,
    0x220033ac,
    0xf18bfa5f,
    0x47984620,
    0x302cf894,
    0x102af894,
    0xeb038922,
    0x440b03c3,
    0x530ef203,
    0x1023f859,
    0xf8491a8a,
    0xf8d82023,
    0x781b3000,
    0xd0642b01,
    0xd0532b02,
    0xd1082b03,
    0x3054f894,
    0xf0002b01,
    0x8de381db,
    0xf10007d9,
    0x4621814c,
    0xf66a4658,
    0x4b3ffc31,
    0x403bf853,
    0xd1a22c00,
    0xecbdb00b,
    0xe8bd8b02,
    0x4b388ff0,
    0xf9b3681b,
    0x2b003000,
    0x808bf2c0,
    0xe9dd4650,
    0xf6761201,
    0x4640fee7,
    0xfbeef659,
    0xe9cd2300,
    0x469a3301,
    0xf8d8e742,
    0xb1b220dc,
    0x8ce38811,
    0x1311eba3,
    0x030bf3c3,
    0x71fef240,
    0xd816428b,
    0xea4f2b3f,
    0xd8121113,
    0x0241eb02,
    0x030ff003,
    0xfa428852,
    0x07d8f303,
    0x9b02d509,
    0x93023301,
    0x0304f44f,
    0x0903ea49,
    0x9010f8c6,
    0xf44fe6fb,
    0xe7f72380,
    0x3054f894,
    0xf0002b01,
    0x8de38117,
    0xd5ae07da,
    0xf6682080,
    0xf8d8ff75,
    0x781b3000,
    0xf894e79c,
    0x2b013054,
    0x80f7f000,
    0x07db8de3,
    0x2080d59f,
    0xff66f668,
    0x3000f8d8,
    0xe78b781b,
    0x3054f894,
    0xf47f2b01,
    0xf890af26,
    0xf0433f20,
    0xf1060302,
    0xf8800110,
    0x22043f20,
    0xf6512012,
    0x8ba1fd2b,
    0x46224809,
    0xf91ef66a,
    0xbf00e713,
    0x00173250,
    0x0003fc40,
    0x00175980,
    0x00171a30,
    0x0017569c,
    0x00172600,
    0x00173278,
    0x001c5904,
    0x00173274,
    0x2b009b03,
    0x808bf040,
    0xf48bfa5f,
    0xf6682080,
    0x4620ff2f,
    0xfebef659,
    0x93032300,
    0xf1bae706,
    0xf47f0f00,
    0x49aaaf71,
    0xf24048aa,
    0xf66a42e7,
    0xe769fac7,
    0xe9d34ba8,
    0x69130201,
    0x46804798,
    0xf43f2800,
    0xf650aee8,
    0x4603fd49,
    0xf0002800,
    0x22008096,
    0x600249a1,
    0x605a6808,
    0x609a4440,
    0xf3ef6018,
    0x07d28210,
    0x812ef140,
    0x6829489c,
    0x31016802,
    0x0201f042,
    0x60026029,
    0x68124a98,
    0xd4fb0790,
    0x68124a97,
    0xf0002a00,
    0x4e968116,
    0x2a006872,
    0x8149f000,
    0x4a926053,
    0x681289b0,
    0x4b906073,
    0x30013201,
    0x601a81b0,
    0x68134a8c,
    0x0301f023,
    0x29006013,
    0xaeadf43f,
    0x39014b8b,
    0x6029681b,
    0xf47f2900,
    0x2b00aea6,
    0xaea3f43f,
    0xe6a0b662,
    0x49866d20,
    0x64a36503,
    0xf8946103,
    0x63e3502b,
    0xf3c29b05,
    0x20a4020e,
    0x0201f042,
    0x3005fb10,
    0x63a4f44f,
    0x1305fb03,
    0xeb0185e2,
    0x4a7c00c0,
    0x46219304,
    0xffe2f668,
    0xf4036b63,
    0xf5b31360,
    0xd0021f60,
    0x93032301,
    0x9804e686,
    0xfd60f656,
    0xf43f2800,
    0x4d73af6f,
    0x31fff895,
    0xf47f2b00,
    0x9b04af69,
    0xf8cd9a08,
    0xfa5fb00c,
    0xf8ddf48b,
    0x46d39014,
    0x4698189e,
    0xe00946ba,
    0xff74f668,
    0x3424f8da,
    0x46214638,
    0xf8954798,
    0xb92331ff,
    0x7039f858,
    0x2f004630,
    0x46dad1f0,
    0xb00cf8dd,
    0x2080e74a,
    0xfe7af668,
    0x4640e6af,
    0xfb92f650,
    0xf899e647,
    0x22043f20,
    0x0302f043,
    0x0110f106,
    0xf8892012,
    0xf6513f20,
    0x8de3fc43,
    0xf53f07da,
    0xe6fdaefc,
    0xf6539306,
    0x9b06f95d,
    0x28009007,
    0x80c0f000,
    0x4b509309,
    0x2a00681a,
    0x80c2f000,
    0xf6684618,
    0x9b07ff39,
    0xf04f2204,
    0x21120e00,
    0x70994684,
    0xf883701a,
    0xf883e001,
    0xf106e003,
    0x18980110,
    0xc018f8cd,
    0xfdc4f678,
    0x8a194b42,
    0xf5b19b09,
    0xd85a7fc3,
    0xb29b1c4b,
    0x00ca9309,
    0x4b3e9806,
    0x68188181,
    0x4b3d9907,
    0x0c02eb00,
    0x0e01f04f,
    0x1004f8cc,
    0x400b5881,
    0x6380f043,
    0x0308f043,
    0xf8995083,
    0x4a333782,
    0x82119909,
    0xf8894473,
    0x9b063782,
    0x22082100,
    0xc004f8c3,
    0xe00ef883,
    0x609a6019,
    0x8310f3ef,
    0xd40307db,
    0x4b25b672,
    0xe000f8c3,
    0x482a682b,
    0x33019906,
    0xf668602b,
    0xf8d7fea5,
    0x47983444,
    0xb133682b,
    0x3b014a1d,
    0x602b6812,
    0xb102b90b,
    0x8de3b662,
    0xf53f07d8,
    0xe67cae7b,
    0x69324b1f,
    0x601a681b,
    0xffaef64e,
    0x4b1de61d,
    0x421c681b,
    0xad37f47f,
    0x481b490a,
    0x6293f44f,
    0xf988f66a,
    0x2200e52f,
    0x46119309,
    0x4a17e7a4,
    0xbb6a6812,
    0x4e094a15,
    0xe6e86013,
    0x4a08b672,
    0xe6cd6016,
    0x001c5ad0,
    0x001c58ec,
    0x001755b4,
    0x001719e4,
    0x40240060,
    0x40240064,
    0x0017559c,
    0x0017569c,
    0x00177738,
    0x001c4001,
    0x00175780,
    0x0017469c,
    0x001755d4,
    0x31ff0000,
    0x001746a4,
    0x00180000,
    0x0017a5a0,
    0x001c58d4,
    0x40240068,
    0x9306480b,
    0xff78f669,
    0x9b066829,
    0x4809e7ca,
    0xf6699306,
    0x6829ff71,
    0xe6b09b06,
    0xb00b4806,
    0x8b02ecbd,
    0x4ff0e8bd,
    0xbcdef64f,
    0xe7f64803,
    0x001c591c,
    0x001c5924,
    0x001c5938,
    0x001c594c,
    0xf240b530,
    0xb0834003,
    0x4619460d,
    0xf6682308,
    0xe9d5f98d,
    0x46043200,
    0x3200e9c0,
    0xe9cd4611,
    0x48042200,
    0xff48f669,
    0xf6684620,
    0x2000f9af,
    0xbd30b003,
    0x001c5970,
    0x460cb570,
    0x4619b084,
    0x4012f240,
    0xf6682308,
    0x6822f971,
    0x429a4b12,
    0xd0104605,
    0x686168a3,
    0xe9c54810,
    0xe9cd2300,
    0x92003301,
    0xf669461a,
    0x4628ff27,
    0xf98ef668,
    0xb0042000,
    0xe9d4bd70,
    0x68116301,
    0x404b4808,
    0x404b4033,
    0xe9d46013,
    0x680a1300,
    0x68a29200,
    0xff12f669,
    0xe7dd6822,
    0x40344058,
    0x001c59cc,
    0x001c59b0,
    0xbf002332,
    0xf0133b01,
    0xd1fa03ff,
    0xbf004770,
    0xbf0023c8,
    0xf0133b01,
    0xd1fa03ff,
    0xbf004770,
    0x49724a71,
    0xf8df6813,
    0xf023c208,
    0xb5f00302,
    0x680b6013,
    0x4c6f4a6e,
    0xf4234f6f,
    0x600b6300,
    0x496e6813,
    0xf4232800,
    0xbf1c7380,
    0x468c4627,
    0x20326013,
    0x3801bf00,
    0x00fff010,
    0xf8dfd1fa,
    0x4a63e18c,
    0x3000f8de,
    0xf4234e65,
    0xf8ce5380,
    0x68133000,
    0x7300f423,
    0xf8de6013,
    0xf4433000,
    0xf8ce6380,
    0xf8de3000,
    0xf4433000,
    0xf8ce6300,
    0x46723000,
    0x1cc125ff,
    0x4664b2c9,
    0xf0236813,
    0x430b03ff,
    0xf8546013,
    0x60333b04,
    0xf4436813,
    0x60137380,
    0xbf00bf00,
    0xbf00bf00,
    0x049b6813,
    0x3901d5fc,
    0x428db2c9,
    0x3004d1e8,
    0x28803504,
    0xf10cb2ed,
    0xd1de0c10,
    0x3000f8de,
    0x6380f423,
    0x3000f8ce,
    0xbf0023c8,
    0xf0133b01,
    0xd1fa03ff,
    0x493f4c3e,
    0x48436822,
    0x6200f422,
    0x680a6022,
    0x0280f042,
    0x680a600a,
    0x7280f442,
    0x600a3f04,
    0xf022680a,
    0x431a021f,
    0xf857600a,
    0x60022f04,
    0xf042680a,
    0x600a0220,
    0xbf00bf00,
    0xbf00bf00,
    0x0552680a,
    0x3301d5fc,
    0xd1e92b10,
    0xf023680b,
    0x600b0380,
    0xbf0023c8,
    0xf0133b01,
    0xd1fa03ff,
    0x4a2d4927,
    0xf423680b,
    0x600b7380,
    0xf4436813,
    0x60131300,
    0xbf002332,
    0xf0133b01,
    0xd1fa03ff,
    0x4a1f4b1e,
    0x4d256819,
    0x48264c25,
    0xf4414e26,
    0x60195180,
    0xf4416811,
    0x60117100,
    0xf4416819,
    0x60196100,
    0x4b216811,
    0x7180f441,
    0x682a6011,
    0xf442491f,
    0x602a5280,
    0xf4226822,
    0x60222280,
    0xf0226802,
    0x60025200,
    0x60306818,
    0x45bbf5a5,
    0x685c3d78,
    0x689d602c,
    0x4a16600d,
    0x601568dd,
    0x691d4815,
    0xe9d36005,
    0x4c145005,
    0x602569db,
    0x61136108,
    0xbf00bdf0,
    0x40580018,
    0x40344060,
    0x4034406c,
    0x001718a4,
    0x00171824,
    0x00171624,
    0x40344064,
    0x40344070,
    0x40344058,
    0x40342014,
    0x40342018,
    0x4034201c,
    0x4033c218,
    0x001718e4,
    0x4033c220,
    0x4033c224,
    0x4033c228,
    0x4033c22c,
    0x00171324,
    0x6c616821,
    0x6e6f615f,
    0x656d6974,
    0x69745f72,
    0x705f656d,
    0x28747361,
    0x656d6974,
    0x743e2d72,
    0x20656d69,
    0x3035202b,
    0x00293030,
    0x616d786e,
    0x69745f63,
    0x6f5f656d,
    0x69615f6e,
    0x61765f72,
    0x5f64696c,
    0x66746567,
    0x21202928,
    0x0030203d,
    0x6d697464,
    0x2c64253a,
    0x252c6425,
    0x64252c64,
    0x00000a0d,
    0x6f76282a,
    0x6974616c,
    0x7520656c,
    0x38746e69,
    0x2a20745f,
    0x5f672629,
    0x5f6e6f61,
    0x72616873,
    0x642e6465,
    0x5f6d6974,
    0x5f746e63,
    0x736e6f61,
    0x65726168,
    0x203c2064,
    0x6f76282a,
    0x6974616c,
    0x7520656c,
    0x38746e69,
    0x2a20745f,
    0x5f672629,
    0x5f6e6f61,
    0x72616873,
    0x642e6465,
    0x5f6d6974,
    0x69726570,
    0x615f646f,
    0x68736e6f,
    0x64657261,
    0x00000000,
    0x00002c4c,
    0x654b849b,
    0x78646979,
    0x766e6920,
    0x64696c61,
    0x3230252c,
    0x00000a58,
    0x6e49849b,
    0x696c6176,
    0x656b2064,
    0x78646979,
    0x0000000a,
    0x6e49849b,
    0x696c6176,
    0x54532064,
    0x64253a41,
    0x0000000a,
    0x5f666976,
    0x20617473,
    0x76203d3d,
    0x00006669,
    0x64253d54,
    0x0d64252c,
    0x0000000a,
    0x3a4e4342,
    0x0a0d6425,
    0x00000000,
    0x206e6362,
    0x656e6f64,
    0x6d697420,
    0x74756f65,
    0x00000a0d,
    0x20736366,
    0x0a0d6b6f,
    0x00000000,
    0x20736366,
    0x20746f6e,
    0x0a0d6b6f,
    0x00000000,
    0x656c6469,
    0x72726520,
    0x00000a0d,
    0x656c6469,
    0x746e6920,
    0x72726520,
    0x00000a0d,
    0x2c642564,
    0x00000000,
    0x0a0d6564,
    0x00000000,
    0x6c616821,
    0x63616d5f,
    0x745f7768,
    0x5f656d69,
    0x74736170,
    0x6d697428,
    0x3e2d7265,
    0x656d6974,
    0x67202d20,
    0x6669775f,
    0x65735f69,
    0x6e697474,
    0x702e7367,
    0x6f5f7277,
    0x5f6e6570,
    0x64737973,
    0x79616c65,
    0x00000029,
    0x78253d74,
    0x00000a0d,
    0x20746f6e,
    0x74736170,
    0x6425203a,
    0x0d64252c,
    0x0000000a,
    0x73736170,
    0x6425203a,
    0x0d64252c,
    0x0000000a,
    0x3a706c73,
    0x252c7825,
    0x000a0d78,
    0x655f656b,
    0x675f7476,
    0x29287465,
    0x65202620,
    0x625f7476,
    0x00007469,
    0x65647874,
    0x665f6373,
    0x74737269,
    0x203d2120,
    0x4c4c554e,
    0x00000000,
    0x73212121,
    0x20646e65,
    0x206d6663,
    0x78253a31,
    0x0d78252c,
    0x0000000a,
    0x0d677562,
    0x0000000a,
    0x6f696473,
    0x69617420,
    0x7265206c,
    0x0d726f72,
    0x0000000a,
    0x3a727265,
    0x206f6e20,
    0x2067736d,
    0x21746b70,
    0x00000a0d,
    0x21727265,
    0x74202121,
    0x63206c78,
    0x6e206d66,
    0x7562206f,
    0x72656666,
    0x726f6620,
    0x62737520,
    0x00000a0d,
    0x4244819d,
    0x57203a47,
    0x69746972,
    0x6d20676e,
    0x726f6d65,
    0x69772079,
    0x30206874,
    0x38302578,
    0x202f2078,
    0x203a6425,
    0x2578305b,
    0x5d783830,
    0x30203d20,
    0x38302578,
    0x202f2078,
    0x000a6425,
    0x6b73616d,
    0x69727720,
    0x253a6574,
    0x78252c78,
    0x2c78252c,
    0x0a0d7825,
    0x00000000,
    0x4244819d,
    0x57203a47,
    0x69746972,
    0x6d20676e,
    0x726f6d65,
    0x69772079,
    0x6d206874,
    0x3a6b7361,
    0x30257830,
    0x202c7838,
    0x61746164,
    0x2578303a,
    0x20783830,
    0x6425202f,
    0x305b203a,
    0x38302578,
    0x3d205d78,
    0x25783020,
    0x20783830,
    0x6425202f,
    0x0000000a,
    0x5f6c6168,
    0x6863616d,
    0x78725f77,
    0x6e63625f,
    0x7275645f,
    0x6f697461,
    0x0000006e,
    0x5f6c6168,
    0x6863616d,
    0x6c735f77,
    0x5f706565,
    0x63656863,
    0x61705f6b,
    0x00686374,
    0x745f6d6d,
    0x5f747462,
    0x706d6f63,
    0x5f657475,
    0x63746170,
    0x00000068,
    0x735f6d6d,
    0x7065656c,
    0x6f666e69,
    0x5f78725f,
    0x5f747665,
    0x63746170,
    0x00000068,
    0x786e7772,
    0x656c735f,
    0x635f7065,
    0x61676b6c,
    0x635f6574,
    0x69666e6f,
    0x61705f67,
    0x00686374,
    0x786e7772,
    0x656c735f,
    0x645f7065,
    0x73706565,
    0x7065656c,
    0x6e6f635f,
    0x5f676966,
    0x63746170,
    0x00000068,
    0x5f6c7874,
    0x5f6d6663,
    0x5f747665,
    0x63746170,
    0x00000068,

};


u32 syscfg_tbl_masked_8800d80[][3] = {
    {0x40506024, 0x000000FF, 0x000000DF}, // for clk gate lp_level
#ifdef CONFIG_PMIC_SETTING
    //{0x50017008, 0x00000002, 0x00000000}, // stop wdg
#endif /* CONFIG_PMIC_SETTING */

};

u32 syscfg_tbl_8800d80[][2] = {
    #ifdef CONFIG_PMIC_SETTING
    {0x70001408, 0x00000000}, // stop wdg
    #endif /* CONFIG_PMIC_SETTING */
};


int aicwf_patch_config_8800d80(struct aic_usb_dev *usb_dev)
{
#if 0
    #ifdef CONFIG_ROM_PATCH_EN
    const u32 rd_patch_addr = 0x10180;
    #else
    const u32 rd_patch_addr = RAM_FMAC_FW_ADDR_8D80 + 0x0194;
    const u32 aic_patch_addr = RAM_FMAC_FW_ADDR_8D80 + 0x019C;
    #endif
    u32 config_base, aic_patch_str_base;
    aic_patch_t *aic_patch;
    uint32_t start_addr = 0x306000;
    u32 patch_addr = start_addr;
    u32 patch_cnt = sizeof(patch_tbl_d80) / 4 / 2;
    struct dbg_mem_read_cfm rd_patch_addr_cfm;
    #ifdef CONFIG_ROM_PATCH_EN
    u32 patch_num1 = sizeof(patch_tbl_1)/4;
    uint32_t start_addr1;
    u32 func_size = sizeof(func_tbl)/4;
    u32 func_start;
    #endif
    int ret = 0;
    u16 cnt = 0;

    printk("Read FW mem: %08x\n", rd_patch_addr);
    if ((ret = rwnx_send_dbg_mem_read_req(usb_dev, rd_patch_addr, &rd_patch_addr_cfm))) {
        printk("setting base[0x%x] rd fail: %d\n", rd_patch_addr, ret);
    }
    printk("%x=%x\n", rd_patch_addr_cfm.memaddr, rd_patch_addr_cfm.memdata);
    config_base = rd_patch_addr_cfm.memdata;

    if ((ret = rwnx_send_dbg_mem_read_req(usb_dev, aic_patch_addr, &rd_patch_addr_cfm))) {
        printk("patch_str_base[0x%x] rd fail: %d\n", aic_patch_addr, ret);
    }
    printk("%x=%x\n", rd_patch_addr_cfm.memaddr, rd_patch_addr_cfm.memdata);
    aic_patch_str_base = rd_patch_addr_cfm.memdata;
    aic_patch = (aic_patch_t *)aic_patch_str_base;

    if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, aic_patch->magic_num, AIC_PATCH_MAGIG_NUM))) {
        printk("maigic_num[0x%x] write fail: %d\n", aic_patch->magic_num, ret);
    }

    if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, aic_patch->pair_start, patch_addr))) {
        printk("pair_start[0x%x] write fail: %d\n", aic_patch->pair_start, ret);
    }

    #ifdef CONFIG_ROM_PATCH_EN
    if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, 0x1e4d2c, patch_num + patch_num1))) {
        printk("%x write fail\n", 0x1e4d2c);
    }
    #else
    if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, aic_patch->pair_count, patch_cnt))) {
        printk("pair_count[0x%x] write fail: %d\n", aic_patch->pair_count, ret);
    }
    #endif

    for (cnt = 0; cnt < patch_cnt; cnt+=1) {
        if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, start_addr+8*cnt, patch_tbl_d80[cnt][0]+config_base))) {
            printk("%x write fail\n", start_addr+8*cnt);
        }

        if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, start_addr+8*cnt+4, patch_tbl_d80[cnt][1]))) {
            printk("%x write fail\n", start_addr+8*cnt+4);
        }
    }

    /*
     *  Patch block 0 ~ 3, that is void by default, can be set as:
     *
     *  const u32 patch_block_0[3] = {0x11223344, 0x55667788, 0xaabbccdd};
     *  if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, (u32)(&aic_patch->block_dst[0]), 0x160000))) {
     *      printk("block_dst [0x%x] write fail: %d\n", (u32)(&aic_patch->block_dst[0]), ret);
     *  }
     *  if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, (u32)(&aic_patch->block_src[0]), 0x307000))) {
     *      printk("block_src [0x%x] write fail: %d\n", (u32)(&aic_patch->block_src[0]), ret);
     *  }
     *  if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, (u32)(&aic_patch->block_size[0]), sizeof(patch_block_0) / sizeof(u32)))) {
     *      printk("block_size[0x%x] write fail: %d\n", (u32)(&aic_patch->block_size[0]), ret);
     *  }
     *  if ((ret = rwnx_send_dbg_mem_block_write_req(usb_dev, 0x307000, sizeof(patch_block_0), patch_block_0))) {
     *      printk("blk set fail: %d\n", ret);
     *  }
     */
    if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, aic_patch->block_size[0], 0))) {
        printk("block_size[0x%x] write fail: %d\n", aic_patch->block_size[0], ret);
    }
    if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, aic_patch->block_size[1], 0))) {
        printk("block_size[0x%x] write fail: %d\n", aic_patch->block_size[1], ret);
    }
    if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, aic_patch->block_size[2], 0))) {
        printk("block_size[0x%x] write fail: %d\n", aic_patch->block_size[2], ret);
    }
    if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, aic_patch->block_size[3], 0))) {
        printk("block_size[0x%x] write fail: %d\n", aic_patch->block_size[3], ret);
    }

    #ifdef CONFIG_ROM_PATCH_EN
    start_addr1 = start_addr+8*cnt;
    for(cnt = 0; cnt < patch_num1/2; cnt+=1)
    {
        if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, start_addr1 + 8*cnt, patch_tbl_1[cnt][0]))) {
            printk("%x write fail\n", start_addr+8*cnt);
        }

        if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, start_addr1 + 8*cnt + 4, patch_tbl_1[cnt][1]))) {
            printk("%x write fail\n", start_addr+8*cnt+4);
        }
    }

    func_start = 0x1c4000;
    for(cnt=0; cnt<func_size; cnt++)
    {
        if ((ret = rwnx_send_dbg_mem_write_req(usb_dev, func_start + 4*cnt, func_tbl[cnt]))) {
            printk("%x write fail\n", start_addr+8*cnt);
        }
    }
    #endif
 #endif
    return 0;
}


#if 0
extern char aic_fw_path[200];

int rwnx_plat_userconfig_load_8800d80(struct aic_usb_dev *usb_dev){
    int size;
    u32 *dst=NULL;
    char *filename = FW_USERCONFIG_NAME_8800D80;

    AICWFDBG(LOGINFO, "userconfig file path:%s \r\n", filename);

    /* load file */
    size = rwnx_request_firmware_common(usb_dev, &dst, filename);
    if (size <= 0) {
            AICWFDBG(LOGERROR, "wrong size of firmware file\n");
            dst = NULL;
            return 0;
    }

	/* Copy the file on the Embedded side */
    AICWFDBG(LOGINFO, "### Load file done: %s, size=%d\n", filename, size);

	rwnx_plat_userconfig_parsing((char *)dst, size);

    rwnx_release_firmware_common(&dst);

    AICWFDBG(LOGINFO, "userconfig download complete\n\n");
    return 0;

}
#endif
int system_config_8800d80(struct aic_usb_dev *usb_dev){
		int syscfg_num;
		int ret, cnt;
		const u32 mem_addr = 0x40500000;
		struct dbg_mem_read_cfm rd_mem_addr_cfm;
		ret = rwnx_send_dbg_mem_read_req(usb_dev, mem_addr, &rd_mem_addr_cfm);
		if (ret) {
			printk("%x rd fail: %d\n", mem_addr, ret);
			return ret;
		}
		chip_id = (u8)(rd_mem_addr_cfm.memdata >> 16);
		printk("chip_id=%x\n", chip_id);
    #if 1
		syscfg_num = sizeof(syscfg_tbl_8800d80) / sizeof(u32) / 2;
		for (cnt = 0; cnt < syscfg_num; cnt++) {
			ret = rwnx_send_dbg_mem_write_req(usb_dev, syscfg_tbl_8800d80[cnt][0], syscfg_tbl_8800d80[cnt][1]);
			if (ret) {
				printk("%x write fail: %d\n", syscfg_tbl_8800d80[cnt][0], ret);
				return ret;
			}
		}
		syscfg_num = sizeof(syscfg_tbl_masked_8800d80) / sizeof(u32) / 3;
		for (cnt = 0; cnt < syscfg_num; cnt++) {
			ret = rwnx_send_dbg_mem_mask_write_req(usb_dev,
				syscfg_tbl_masked_8800d80[cnt][0], syscfg_tbl_masked_8800d80[cnt][1], syscfg_tbl_masked_8800d80[cnt][2]);
			if (ret) {
				printk("%x mask write fail: %d\n", syscfg_tbl_masked_8800d80[cnt][0], ret);
				return ret;
			}
		}
    #endif
    return 0;
}

int aicfw_download_fw_8800d80(struct aic_usb_dev *usb_dev){
    if(testmode == FW_NORMAL_MODE){
		if (chip_id != CHIP_REV_U01){
			if(rwnx_plat_bin_fw_upload_android(usb_dev, FW_RAM_ADID_BASE_ADDR_8800D80_U02, FW_ADID_BASE_NAME_8800D80_U02)) {
				return -1;
			}
			if(rwnx_plat_bin_fw_upload_android(usb_dev, FW_RAM_PATCH_BASE_ADDR_8800D80_U02, FW_PATCH_BASE_NAME_8800D80_U02)) {
				return -1;
			}
			if (rwnx_plat_bin_fw_patch_table_upload_android(usb_dev, FW_PATCH_TABLE_NAME_8800D80_U02)) {
				return -1;
			}
			if(rwnx_plat_bin_fw_upload_android(usb_dev, RAM_FMAC_FW_ADDR_8800D80_U02, FW_BASE_NAME_8800D80_U02)) {
				return -1;
			}
#if 0
            if(rwnx_plat_bin_fw_upload_android(usb_dev, FW_RAM_CPUS_UART1_ADDR_8800D80_U02, FW_CPUS_UART1_NAME_8800D80_U02)) {
				return -1;
			}
#endif
            if (rwnx_send_dbg_mem_write_req(usb_dev, 0x40500048, 0x1e0000))
                return -1;
			if (rwnx_send_dbg_start_app_req(usb_dev, RAM_FMAC_FW_ADDR_8800D80_U02, HOST_START_APP_AUTO)) {
				return -1;
			}
		}else {
			if(rwnx_plat_bin_fw_upload_android(usb_dev, FW_RAM_ADID_BASE_ADDR_8800D80, FW_ADID_BASE_NAME_8800D80)) {
				return -1;
			}
			if(rwnx_plat_bin_fw_upload_android(usb_dev, FW_RAM_PATCH_BASE_ADDR_8800D80, FW_PATCH_BASE_NAME_8800D80)) {
				return -1;
			}
			if (rwnx_plat_bin_fw_patch_table_upload_android(usb_dev, FW_PATCH_TABLE_NAME_8800D80)) {
				return -1;
			}
                        if(rwnx_plat_bin_fw_upload_android(usb_dev, RAM_FMAC_FW_ADDR_8800D80, FW_BASE_NAME_8800D80)) {
				return -1;
                        }
		        if (rwnx_send_dbg_start_app_req(usb_dev, RAM_FMAC_FW_ADDR_8800D80, HOST_START_APP_AUTO)) {
				return -1;
        }
		}
    }else if(testmode == FW_TEST_MODE){
	    if (chip_id != CHIP_REV_U01){

			if(rwnx_plat_bin_fw_upload_android(usb_dev, FW_RAM_ADID_BASE_ADDR_8800D80_U02, FW_ADID_BASE_NAME_8800D80_U02)) {
				return -1;
			}

			if(rwnx_plat_bin_fw_upload_android(usb_dev, FW_RAM_PATCH_BASE_ADDR_8800D80_U02, FW_PATCH_BASE_NAME_8800D80_U02)) {
				return -1;
			}
			if (rwnx_plat_bin_fw_patch_table_upload_android(usb_dev, FW_PATCH_TABLE_NAME_8800D80_U02)) {
				return -1;
			}

			if(rwnx_plat_bin_fw_upload_android(usb_dev, RAM_FMAC_RF_FW_ADDR_8800D80_U02, FW_RF_BASE_NAME_8800D80_U02)) {
				AICWFDBG(LOGERROR,"%s wifi fw download fail \r\n", __func__);
				return -1;
			}
			if (rwnx_send_dbg_start_app_req(usb_dev, RAM_FMAC_RF_FW_ADDR_8800D80_U02, HOST_START_APP_AUTO)) {
				return -1;
			}
	    } else {
                        if(rwnx_plat_bin_fw_upload_android(usb_dev, RAM_FMAC_RF_FW_ADDR_8800D80, FW_RF_BASE_NAME_8800D80)) {
                         AICWFDBG(LOGERROR,"%s wifi fw download fail \r\n", __func__);
                                return -1;
                        }
                        if (rwnx_send_dbg_start_app_req(usb_dev, RAM_FMAC_RF_FW_ADDR_8800D80, HOST_START_APP_AUTO)) {
                                return -1;
                        }
	    }
    }
    return 0;
}


